public class ProgramBinomialCoef {

	private static void doJob(IBinomialCoef binomialCalculator) {
		int n, k;
		long rez;
		long startTime, endTime, duration;

		System.out.println("A small test first:");
		System.out.println("C(4,2)=" + binomialCalculator.C(4, 2));
		System.out.println("C(6,2)=" + binomialCalculator.C(6, 2));
		
		System.out.println("And now get ready for real work !");
		for (n = 20; n < 50; n = n + 5) {
			k = n / 2;
			System.out.print("Starting to work at C(" + n + "," + k + ") ... ");
			startTime = System.nanoTime();
			rez = binomialCalculator.C(n, k);
			endTime = System.nanoTime();
			duration = (endTime - startTime);
			System.out.println("Done in " + duration / 1000000 + " milisec");
			System.out.println("Result is " + rez);
		}
	}

	public static void main(String[] args) {

		IBinomialCoef calculator1, calculator2, calculator3;

		System.out.println("\n The Recursive Version: ");
		calculator1 = new BinomialCoefRec();
		doJob(calculator1);

		System.out.println("\n The Memoization Version: ");
		calculator2 = new BinomialCoefMemoization();
		doJob(calculator2);

		System.out.println("\n The Dynamic Programming Version: ");
		calculator3 = new BinomialCoefDynProg();
		doJob(calculator3);

		System.out.println("\n The Dynamic Programming Mem Efficient Version: ");
		calculator3 = new BinomialCoefDynProgMemEff();
		doJob(calculator3);

	}

}
