import java.util.ArrayList;
import java.util.Vector;


public interface IKnapsackComplete {
	
	/**
	 * The complete version of the problem:
	 * Finds the solution (the set of selected items) of the 
	 * integer exact knapsack problem.
	 * 
	 * @param weights represent the weights of the candidates
	 * @param last is the index of the last candidate (size-1)
	 * @param k is the total allowed weight 
	 * @return an array list of the selected weights or null if there is no solution 
	 */
  ArrayList<Integer> getSolution(Vector<Integer> weights, int last, int k);		
}
